<?php
    // --- CONFIGURACIÓN DE PAGO ---
    $monto = 27; // Monto para esta página específica
    $mensaje_whatsapp = urlencode("Hola, estoy en la página de pago para la oferta de $" . $monto . " y tengo un problema. Necesito ayuda para completar mi pedido.");
    $url_whatsapp = "https://wa.me/14257772109?text=" . $mensaje_whatsapp;

    $redirect_url = '#'; // Fallback URL
    if (isset($_GET['p'])) {
        if ($_GET['p'] === 'card') {
            $redirect_url = 'https://checkout.dodopayments.com/buy/pdt_C2Y6auvL6d1oOMfbvzRZM?quantity=1&redirect_url=https://generamasclientes.com%2Fconfirmacion-primer-pago-pagina-web.php&showDiscounts=false';
        } elseif ($_GET['p'] === 'paypal') {
            $redirect_url = 'https://www.paypal.com/ncp/payment/6S9844337E4J8';
        }
    }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

    <title>Redirigiendo A Pasarela De Pago Seguro | LocalWebPro</title>
    <meta name="description" content="Espera un momento mientras te redirigimos a nuestra plataforma de pago 100% segura para completar tu pedido. Tu inversión está protegida.">
    <meta name="robots" content="noindex, nofollow">

    <?php require_once 'files/gtm_head.php'; ?>
    
    <link rel="icon" href="img/favicon.webp" sizes="any">
    <link rel="icon" href="img/favicon.webp" type="image/svg+xml">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.webp">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d', /* Azul Oscuro (Inteligencia) */
                        'brand-secondary': '#9e1428', /* Rojo (Creatividad) */
                        'brand-highlight': '#ffc857', /* Amarillo (Visión) */
                        'brand-light-bg': '#f5f5f5', /* Blanco (Honestidad) */
                        'brand-white': '#FFFFFF',
                        'brand-dark-text': '#07080a', /* Negro (Prestigio) - para textos principales */
                        'brand-light-text': '#f3f4f6', /* Mantener para textos claros sobre fondos oscuros */
                        'dark-red-bg': '#9e1428', /* Usar Rojo Secundario para fondos específicos */
                        'dark-black-bg': '#07080a', /* Nuevo: Negro (Prestigio) para fondos */
                    },
                    fontFamily: { 'sans': ['Barlow', 'sans-serif'] }
                }
            }
        }
    </script>
    
    <style>
        html { scroll-behavior: smooth; overflow-x: hidden; }
        body { -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; }
        .loading-dot { animation: bounce 1.4s infinite ease-in-out both; }
        .loading-dot:nth-child(2) { animation-delay: .2s; }
        .loading-dot:nth-child(3) { animation-delay: .4s; }
        @keyframes bounce { 0%, 80%, 100% { transform: scale(0); } 40% { transform: scale(1); } }
    </style>
</head>

<body class="font-sans bg-brand-primary text-brand-light-text overflow-x-hidden">
    
    <?php require_once 'files/gtm_body.php'; ?>

    <?php
        if ($redirect_url !== '#') {
            echo "<script>setTimeout(function(){window.location.href='". $redirect_url ."';}, 3000);</script>";
        }
    ?>
    
    <main class="relative min-h-screen flex items-center justify-center isolate overflow-hidden p-4">
        <div class="absolute inset-0 -z-10 bg-brand-primary"></div>
        <div class="absolute inset-0 -z-10 opacity-20" style="background:
            radial-gradient(60rem 60rem at 10% 10%, #9e1428 0%, transparent 50%),
            radial-gradient(50rem 50rem at 90% 90%, #ffc857 0%, transparent 45%);
        "></div>

        <div class="w-full max-w-7xl mx-auto grid lg:grid-cols-2 gap-12 items-center">
            
            <div class="flex flex-col items-center lg:items-start text-center lg:text-left" data-aos="fade-right">
                <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-brand-secondary/90 text-brand-highlight font-semibold tracking-widest uppercase ring-1 ring-brand-highlight/30 shadow-sm text-xs md:text-sm">
                    <i data-lucide="zap" class="w-4 h-4"></i>
                    UN PASO MÁS PARA EMPEZAR
                </p>

                <div class="mt-8 relative w-full max-w-md">
                    <img src="img/Paquete-Web.webp" alt="Paquete LocalWeb Pro" class="w-full h-auto">
                </div>
                
                <h1 class="mt-5 text-4xl md:text-5xl lg:text-6xl font-black uppercase leading-tight text-white">
                    ¡HAS TOMADO UNA EXCELENTE DECISIÓN!
                </h1>

                <p class="mt-5 text-lg md:text-xl text-gray-200 max-w-xl">
                    Espera Mientras Te Redirigimos A La Plataforma De Pago Segura Para Completar Tu Pedido
                </p>

                <div class="flex items-center mt-10 gap-2">
                    <span class="loading-dot w-3 h-3 md:w-4 md:h-4 bg-brand-highlight rounded-full"></span>
                    <span class="loading-dot w-3 h-3 md:w-4 md:h-4 bg-brand-highlight rounded-full"></span>
                    <span class="loading-dot w-3 h-3 md:w-4 md:h-4 bg-brand-highlight rounded-full"></span>
                    <span class="text-sm md:text-base text-gray-300 ml-2">Redirigiendo…</span>
                </div>
            </div>

            <div class="flex flex-col" data-aos="fade-left" data-aos-delay="100">

                <div class="bg-white/5 rounded-xl p-6 ring-1 ring-white/10 w-full max-w-md mx-auto lg:mx-0">
                    <h3 class="text-lg font-bold text-white text-center uppercase tracking-wider">Resumen de tu Pago Inicial</h3>
                    <div class="mt-4 border-t border-white/20 pt-4 space-y-3 text-lg">
                        <div class="flex justify-between">
                            <span class="text-gray-300">Pago Inicial:</span>
                            <span class="font-bold text-white">$27 USD</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-300">Impuestos (si aplican):</span>
                            <span class="font-bold text-white">Calculado En El Checkout</span>
                        </div>
                        <div class="flex justify-between border-t border-brand-highlight mt-3 pt-3">
                            <span class="font-bold text-brand-highlight text-xl">Total A Pagar Hoy:</span>
                            <span class="font-black text-brand-highlight text-2xl">$27 USD</span>
                        </div>
                    </div>
                     <p class="text-xs text-gray-400 mt-4 text-center">
                        * El Monto Final, Incluyendo Impuestos, Se Mostrará En La Pasarela De Pago.
                    </p>
                </div>
                
                <div class="mt-8 w-full max-w-md space-y-6 mx-auto lg:mx-0">
                    <div class="flex items-start gap-4">
                        <i data-lucide="shield-check" class="w-8 h-8 text-brand-highlight flex-shrink-0 mt-1"></i>
                        <div>
                            <strong class="text-lg font-bold text-white block">Garantía Cero Riesgo</strong>
                            <span class="text-gray-300">No pagas el resto si no te gusta el resultado final.</span>
                        </div>
                    </div>
                    <div class="flex items-start gap-4">
                        <i data-lucide="lock" class="w-8 h-8 text-brand-highlight flex-shrink-0 mt-1"></i>
                        <div>
                            <strong class="text-lg font-bold text-white block">Pago 100% Seguro</strong>
                            <span class="text-gray-300">Transacciones procesadas a través de plataformas encriptadas.</span>
                        </div>
                    </div>
                </div>

                                <div class="mt-10 flex flex-col sm:flex-row items-center gap-4 w-full max-w-md mx-auto lg:mx-0">
                    <a href="<?php echo htmlspecialchars($redirect_url); ?>" class="inline-flex items-center justify-center gap-2 px-6 py-3 text-base font-extrabold rounded-xl bg-brand-highlight text-brand-primary uppercase transition hover:bg-yellow-400 hover:translate-y-[-2px] shadow-lg w-full sm:w-auto">
                        <i data-lucide="credit-card" class="w-5 h-5"></i>
                        <span>Continuar</span>
                    </a>
                    <a href="<?php echo htmlspecialchars($url_whatsapp); ?>" target="_blank" class="inline-flex items-center justify-center gap-2 px-6 py-3 text-base font-bold rounded-xl bg-transparent text-brand-highlight ring-1 ring-inset ring-brand-highlight hover:bg-brand-highlight hover:text-brand-primary transition-colors duration-200 w-full sm:w-auto">
                        <i data-lucide="message-square" class="w-5 h-5"></i>
                        <span>¿TIENES PROBLEMAS?</span>
                    </a>
                </div>
             </div>
        </div>
    </main>
    
    <?php require_once 'files/footer.php'; ?>

    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Inicializar AOS
            if (typeof AOS !== 'undefined') {
                AOS.init({
                    duration: 800,
                    once: true,
                    offset: 50,
                    easing: 'ease-out-cubic'
                });
            }
            // Crear Iconos Lucide
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
            // Actualizar año en el footer
            const yearEl = document.getElementById('year');
            if (yearEl) {
                yearEl.textContent = new Date().getFullYear();
            }
        });
    </script>
</body>
</html>