<?php
header('Content-Type: application/json');

$response = array('success' => false, 'message' => '');

// Dirección de correo a la que se enviará el formulario.
$recipient = "orozdesign@gmail.com";

// Correo que aparecerá como remitente (mejora la entrega).
$sender_email = "no-reply@generamasclientes.com";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Recopilar y sanear los datos del formulario
    $name = trim(filter_input(INPUT_POST, 'name', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
    $email = trim(filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL));
    $phone = trim(filter_input(INPUT_POST, 'phone', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
    $service = "N/A"; // Valor por defecto si no se envía el servicio
    if(isset($_POST['service'])) {
        $service = trim(filter_input(INPUT_POST, 'service', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
    }
    $message = trim(filter_input(INPUT_POST, 'message', FILTER_SANITIZE_FULL_SPECIAL_CHARS));

    // --- LÓGICA ANTI-SPAM (TU CÓDIGO) ---
    $is_valid_phone = preg_match('/^\d{10}$/', str_replace(['(', ')', '-', ' '], '', $phone));
    $has_links = preg_match('/https?:\/\/[^\s]+/i', $message);
    $blocked_keywords = ['collaboration', 'affiliates', 'payouts', 'monkey digital', 'seo', 'sem', 'google ads', 'meta ads', 'marketing digital', 'digital marketing', 'publicidad', 'posicionamiento web', 'estrategia', 'marketing', 'online marketing'];
    $is_spam_keyword = false;
    foreach ($blocked_keywords as $keyword) {
        if (stripos($message, $keyword) !== false || stripos($name, $keyword) !== false) {
            $is_spam_keyword = true;
            break;
        }
    }
    $is_english_or_spanish = preg_match('/^[a-zA-Z0-9\s.,;?¿¡!ñÑáéíóúÁÉÍÓÚüÜ@()\-+]*$/u', $message);
    $is_valid_name = preg_match('/^[a-zA-Z\sñÑáéíóúÁÉÍÓÚüÜ]*$/u', $name);
    // --- FIN DEL BLOQUE ANTI-SPAM ---

    $is_spam = !$is_valid_phone || $has_links || $is_spam_keyword || !$is_english_or_spanish || !$is_valid_name;

    if ($is_spam) {
        $response['success'] = true;
        $response['message'] = '¡Tu mensaje ha sido enviado! Lo revisaremos pronto.';
    } elseif (empty($name) || empty($email) || empty($phone) || empty($message) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response['success'] = false; // Error real para campos vacíos.
        $response['message'] = 'Por favor, completa todos los campos requeridos.';
    } else {
        // Si todo está correcto y no es spam, envía el correo real
        $email_subject = "Nueva Solicitud de Información de: $name";
        $email_content = "Nombre: $name\n";
        $email_content .= "Correo Electrónico: $email\n";
        $email_content .= "Teléfono: $phone\n";
        if ($service !== "N/A") {
            $email_content .= "Servicio Solicitado: $service\n";
        }
        $email_content .= "Mensaje:\n$message\n";
        
        // Cabeceras de correo mejoradas para evitar spam
        $email_headers = "From: " . $name . " <" . $sender_email . ">\r\n";
        $email_headers .= "Reply-To: " . $email . "\r\n";
        $email_headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $email_headers .= "X-Mailer: PHP/" . phpversion();

        if (@mail($recipient, $email_subject, $email_content, $email_headers)) {
            $response['success'] = true;
            $response['message'] = '¡Mensaje enviado con éxito! Nos pondremos en contacto pronto.';
        } else {
            $response['message'] = 'Hubo un problema en el servidor al enviar tu mensaje. Por favor, inténtalo de nuevo más tarde.';
        }
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

echo json_encode($response);
?>